/*
 * Decompiled with CFR 0.152.
 */
package com.stampysoft.ant.j2me;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class JARToPRCTask
extends Task {
    private boolean m_beam = false;
    private boolean m_verbose = false;
    private boolean m_networking = false;
    private File m_jar;
    private String m_prc;
    private String m_mainClass;
    private String m_version;
    private String m_name;
    private String m_longName;
    private String m_creator;
    private String m_type;
    private String m_classpath;
    private String m_bootclasspath;
    private File m_jad;
    private File m_icon;
    private File m_listIcon;
    private File m_smallIcon;
    private String m_toolkitVersion;
    private static final String VERSION_1_0 = "1.0";
    private static final String VERSION_1_0_EARLY_ACCESS = "1.0EA";

    public void setBeam(boolean bl) {
        this.m_beam = bl;
    }

    public void setVerbose(boolean bl) {
        this.m_verbose = bl;
    }

    public void setNetworking(boolean bl) {
        this.m_networking = bl;
    }

    public void setJar(File file) {
        this.m_jar = file;
    }

    public void setPRC(String string) {
        this.m_prc = string;
    }

    public void setMainClass(String string) {
        this.m_mainClass = string;
    }

    public void setVersion(String string) {
        this.m_version = string;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public void setLongname(String string) {
        this.m_longName = string;
    }

    public void setCreator(String string) {
        this.m_creator = string;
    }

    public void setType(String string) {
        this.m_type = string;
    }

    public void setClasspath(String string) {
        this.m_classpath = string;
    }

    public void setBootclasspath(String string) {
        this.m_bootclasspath = string;
    }

    public void setJad(File file) {
        this.m_jad = file;
    }

    public void setIcon(File file) {
        this.m_icon = file;
    }

    public void setListicon(File file) {
        this.m_listIcon = file;
    }

    public void setSmallicon(File file) {
        this.m_smallIcon = file;
    }

    private String getCommandLineArgs() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_version != null) {
            stringBuffer.append("-version ");
            stringBuffer.append(this.m_version);
            stringBuffer.append(" ");
        }
        if (this.m_icon != null) {
            this.checkIconFile(this.m_icon, "icon");
            stringBuffer.append("-icon \"");
            stringBuffer.append(this.m_icon);
            stringBuffer.append("\" ");
        }
        if (this.m_smallIcon != null) {
            this.checkIconFile(this.m_smallIcon, "smallicon");
            stringBuffer.append("-smallicon \"");
            stringBuffer.append(this.m_smallIcon);
            stringBuffer.append("\" ");
        }
        if (this.m_name != null) {
            stringBuffer.append("-name \"");
            stringBuffer.append(this.m_name);
            stringBuffer.append("\" ");
            if (this.m_longName == null) {
                this.m_longName = this.m_name;
            }
        }
        if (this.m_longName != null) {
            stringBuffer.append("-longname \"");
            stringBuffer.append(this.m_longName);
            stringBuffer.append("\" ");
        }
        if (this.m_creator != null) {
            stringBuffer.append("-creator ");
            stringBuffer.append(this.m_creator);
            stringBuffer.append(" ");
        }
        if (this.m_type != null) {
            stringBuffer.append("-type ");
            stringBuffer.append(this.m_type);
            stringBuffer.append(" ");
        }
        if (this.m_classpath != null) {
            stringBuffer.append("-classpath \"");
            stringBuffer.append(this.m_classpath);
            stringBuffer.append("\" ");
        }
        if (this.m_bootclasspath != null) {
            stringBuffer.append("-bootclasspath \"");
            stringBuffer.append(this.m_bootclasspath);
            stringBuffer.append("\" ");
        }
        if (this.m_verbose) {
            stringBuffer.append("-v ");
        }
        if (!this.m_beam) {
            stringBuffer.append("-nobeam ");
        }
        if (this.m_networking) {
            stringBuffer.append("-networking ");
        }
        if (this.m_listIcon != null) {
            this.checkIconFile(this.m_listIcon, "listicon");
            stringBuffer.append("-listicon \"");
            stringBuffer.append(this.m_listIcon);
            stringBuffer.append("\" ");
        }
        stringBuffer.append("-o \"");
        if (this.m_prc == null) {
            this.m_prc = this.m_jar.getName().substring(0, this.m_jar.getName().length() - ".jar".length()) + ".prc";
        }
        stringBuffer.append(this.m_prc);
        stringBuffer.append("\" ");
        if (this.m_jad != null) {
            stringBuffer.append("-jad \"");
            stringBuffer.append(this.m_jad);
            stringBuffer.append("\" ");
        }
        if (this.m_toolkitVersion.equals(VERSION_1_0_EARLY_ACCESS)) {
            stringBuffer.append("-JARtoPRC \"");
            stringBuffer.append(this.m_jar);
            stringBuffer.append("\" ");
            stringBuffer.append(this.m_mainClass);
        } else {
            stringBuffer.append("\"");
            stringBuffer.append(this.m_jar);
            stringBuffer.append("\" ");
        }
        return stringBuffer.toString();
    }

    private void checkIconFile(File file, String string) throws BuildException {
        if (!file.isFile()) {
            throw new BuildException(string + " file does not exist or is not a file", this.location);
        }
    }

    private void determineConverterVersion(File file) throws BuildException {
        try {
            JarFile jarFile = new JarFile(file);
            this.m_toolkitVersion = jarFile.getJarEntry("palm/database/MakeMIDPApp.class") != null ? VERSION_1_0_EARLY_ACCESS : VERSION_1_0;
        }
        catch (IOException iOException) {
            throw new BuildException("Unable to determine MIDP for Palm toolkit version");
        }
    }

    public void execute() throws BuildException {
        String string = this.project.getProperty("midp4palm.home");
        File file = new File(string + File.separator + "MakeMIDPApp.jar");
        if (!file.isFile() && !(file = new File(string + File.separator + "Converter" + File.separator + "Converter.jar")).isFile()) {
            throw new BuildException("Unable to find MakeMIDPApp.jar, be sure that \"midp4palm.home\" property is set correctly", this.location);
        }
        this.determineConverterVersion(file);
        if (this.m_jar == null) {
            throw new BuildException("You must specify a JAR file containing classes for your application with the \"jar\" attribute", this.location);
        }
        if (!this.m_jar.getName().endsWith(".jar") && !this.m_jar.getName().endsWith(".zip")) {
            throw new BuildException("The specified jar file must have a .jar or .zip extension", this.location);
        }
        if (!this.m_jar.isFile()) {
            throw new BuildException("The specified jar, " + this.m_jar + ", either does not exist or is not a file", this.location);
        }
        if (this.m_jad != null) {
            if (!this.m_jad.isFile()) {
                throw new BuildException("The specified jad, " + this.m_jad + ", either does not exist or is not a file", this.location);
            }
        } else if (this.m_mainClass == null) {
            throw new BuildException("If you are not using a JAD you must specify a \"mainclass\" attribute as the entry point to your MIDlet");
        }
        Java java = (Java)this.project.createTask("java");
        java.setTaskName(this.getTaskName());
        java.setFork(true);
        if (this.m_toolkitVersion.equals(VERSION_1_0_EARLY_ACCESS)) {
            java.setClassname("palm.database.MakeMIDPApp");
        } else {
            java.setClassname("com.sun.midp.palm.database.MakeMIDPApp");
        }
        String string2 = this.getCommandLineArgs();
        this.log("Creating " + this.m_prc + " with toolkit version " + this.m_toolkitVersion);
        this.log("Arguments to MakeMIDPApp: " + string2, 3);
        Commandline.Argument argument = java.createArg();
        argument.setLine(string2);
        Path path = new Path(this.project);
        path.setLocation(file);
        java.setClasspath(path);
        if (java.executeJava() != 0) {
            throw new BuildException("Execution of MakeMIDPApp helper failed");
        }
    }
}

